/*
 * Decompiled with CFR 0.152.
 */
package bird.comm;

import bird.comm.CommExc;
import bird.comm.CommInt;
import bird.util.CircBuf;
import bird.util.Dbg;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class SerialCommInt
implements CommInt,
Runnable {
    private DataInputStream dis_;
    private DataOutputStream dos_;
    private boolean isOpen_;
    private Thread commListenerTh_;
    private boolean mustStop_;
    private CircBuf inBuf_;
    private boolean isIOPending_;
    private SerialPort serialPort_;
    private String portName_;
    private int paramBaud_;
    private int paramDataBits_;
    private int paramStopBits_;
    private int paramParity_;
    private String appOwnerName_;

    public SerialCommInt(String string, int n, String string2) {
        this(string, 9600, 8, 1, 0, n, string2);
    }

    public SerialCommInt(String string, int n, int n2, int n3, int n4, int n5, String string2) {
        this.appOwnerName_ = string2;
        this.serialPort_ = null;
        this.portName_ = string;
        this.paramBaud_ = n;
        this.paramDataBits_ = n2;
        this.paramStopBits_ = n3;
        this.paramParity_ = n4;
        this.dis_ = null;
        this.dos_ = null;
        this.isOpen_ = false;
        this.isIOPending_ = false;
        this.mustStop_ = true;
        this.inBuf_ = new CircBuf(n5);
        this.commListenerTh_ = new Thread((Runnable)this, "CommListener");
    }

    public synchronized void open() throws CommExc {
        if (this.isOpen_) {
            throw new CommExc("Aleady open!");
        }
        CommPortIdentifier commPortIdentifier = null;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements() && ((commPortIdentifier = (CommPortIdentifier)enumeration.nextElement()).getPortType() != 1 || commPortIdentifier.isCurrentlyOwned() || !commPortIdentifier.getName().equals(this.portName_))) {
        }
        if (commPortIdentifier == null) {
            throw new CommExc(this.portName_ + " not available.");
        }
        try {
            this.serialPort_ = (SerialPort)commPortIdentifier.open(this.appOwnerName_, 2000);
            this.serialPort_.setSerialPortParams(this.paramBaud_, this.paramDataBits_, this.paramStopBits_, this.paramParity_);
            this.dis_ = new DataInputStream(new BufferedInputStream(this.serialPort_.getInputStream()));
            this.dos_ = new DataOutputStream(new BufferedOutputStream(this.serialPort_.getOutputStream()));
        }
        catch (Exception exception) {
            try {
                this.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new CommExc("Unable to open " + this.portName_ + "!", exception);
        }
        this.isOpen_ = true;
        this.isIOPending_ = false;
        this.inBuf_.clear(true, 0);
        this.setMustStop(false);
        this.commListenerTh_.start();
    }

    public synchronized void close() {
        this.isIOPending_ = false;
        if (this.isOpen_) {
            this.isOpen_ = false;
            try {
                this.inBuf_.clear(true, 0);
                if (this.commListenerTh_.isAlive()) {
                    this.setMustStop(true);
                    this.wakeupTh();
                    this.commListenerTh_.join(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.serialPort_ != null) {
                this.serialPort_.close();
                this.serialPort_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dis_ != null) {
                this.dis_.close();
                this.dis_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dos_ != null) {
                this.dos_.close();
                this.dos_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void purge() {
        this.inBuf_.clear(true, 0);
    }

    public synchronized int send(byte[] byArray, int n, int n2) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        this.isIOPending_ = true;
        int n3 = 0;
        try {
            this.dos_.write(byArray, 0, n);
            this.dos_.flush();
            n3 = n;
            this.isIOPending_ = false;
            Thread.yield();
        }
        catch (Exception exception) {
            this.isIOPending_ = false;
            throw new CommExc(exception);
        }
        return n3;
    }

    public synchronized int receive(byte[] byArray, int n, int n2) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        long l = System.currentTimeMillis() + (long)n2;
        while (this.inBuf_.getLength() < n && System.currentTimeMillis() <= l) {
            Thread.yield();
        }
        return this.inBuf_.getElements(byArray, n);
    }

    public synchronized int receiveAvail(byte[] byArray) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        if (byArray == null) {
            return 0;
        }
        return this.inBuf_.getElements(byArray, Math.min(byArray.length, this.inBuf_.getLength()));
    }

    public synchronized byte[] receiveUntilDelim(byte by, int n) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        byte[] byArray = null;
        long l = System.currentTimeMillis() + (long)n;
        while (true) {
            int n2;
            if ((n2 = this.inBuf_.findElement(by)) != -1) {
                byArray = new byte[n2 + 1];
                Arrays.fill(byArray, (byte)0);
                this.inBuf_.getElements(byArray, n2 + 1);
                break;
            }
            if (System.currentTimeMillis() > l) break;
            Thread.yield();
        }
        return byArray;
    }

    public int numBytesAvail() {
        return this.inBuf_.getLength();
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    public boolean isIOPending() {
        return this.isIOPending_;
    }

    public void run() {
        Dbg.getInst().log("Started.", Dbg.LVL_SYS);
        byte[] byArray = new byte[this.inBuf_.getSize()];
        int n = 0;
        int n2 = 0;
        while (!this.getMustStop()) {
            try {
                Arrays.fill(byArray, (byte)0);
                n = this.dis_.read(byArray, 0, 1);
                this.inBuf_.addElements(byArray, n);
                n2 = Math.min(this.dis_.available(), byArray.length);
                if (n2 <= 0 || (n = this.dis_.read(byArray, 0, n2)) <= 0) continue;
                this.inBuf_.addElements(byArray, n);
            }
            catch (Exception exception) {
                Thread.yield();
            }
        }
        Dbg.getInst().log("Stopped gracefully.", Dbg.LVL_SYS);
    }

    private synchronized void setMustStop(boolean bl) {
        this.mustStop_ = bl;
    }

    private boolean getMustStop() {
        return this.mustStop_;
    }

    private synchronized void wakeupTh() {
        try {
            this.commListenerTh_.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
    }

    public static String[] getAvailSerialPorts() {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>(10);
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1 || commPortIdentifier.isCurrentlyOwned()) continue;
            vector.add(commPortIdentifier.getName());
        }
        int n = vector.size();
        if (n > 0) {
            objectArray = new String[n];
            try {
                vector.copyInto(objectArray);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return objectArray;
    }
}

